/*
 * Decompiled with CFR 0.152.
 */
package org.jcochran.j2mechat;

import java.util.Calendar;
import java.util.TimeZone;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import org.jcochran.j2mechat.HelloMidlet;
import org.jcochran.j2mechat.imListener;

public class chatWindow
extends Form
implements CommandListener {
    private String buddyName;
    private StringItem conversation;
    private TextField imInput;
    Command exitCommand;
    Command sendCommand;
    Command backToListCommand;
    private HelloMidlet parent;
    private boolean mkForDel = false;

    chatWindow(String buddyName, HelloMidlet parent) {
        super("Chatting with: " + buddyName);
        this.buddyName = buddyName.toLowerCase();
        this.parent = parent;
        this.sendCommand = new Command("Send IM", 1, 0);
        this.imInput = new TextField("", "", 1024, 0);
        this.imInput.setPreferredSize(this.getWidth(), 20);
        this.imInput.setLayout(32);
        this.append((Item)this.imInput);
        this.imInput.setItemCommandListener((ItemCommandListener)new imListener(this));
        this.imInput.setDefaultCommand(this.sendCommand);
        this.exitCommand = new Command("Close", 1, 0);
        this.backToListCommand = new Command("Back To Buddy List", 1, 0);
        this.imInput.addCommand(this.sendCommand);
        this.imInput.setDefaultCommand(this.sendCommand);
        this.addCommand(this.backToListCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void destroyApp(boolean unconditional) {
    }

    public void setDel(boolean setTo) {
        this.mkForDel = setTo;
    }

    public boolean shouldDelete() {
        return this.mkForDel;
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            this.parent.closeChatWindow(this);
        }
        if (c == this.backToListCommand) {
            this.parent.returnToBudyForm();
        }
        if (c == this.sendCommand) {
            this.doSendIM();
        }
    }

    void doSendIM() {
        if (this.imInput.getString() == null || this.imInput.getString().equals("")) {
            return;
        }
        this.parent.sendIM(this.buddyName, this.imInput.getString());
        int fontSize = 8;
        if (this.parent.getChatFontSize() == 2) {
            fontSize = 16;
        }
        if (this.parent.getChatFontSize() == 1) {
            fontSize = 0;
        }
        Font myFont = Font.getFont((int)64, (int)0, (int)fontSize);
        StringItem newText = !this.parent.isTimestamp() ? new StringItem("", "You: " + this.imInput.getString()) : new StringItem("", "(" + this.formattedDate() + ") " + "You: " + this.imInput.getString());
        newText.setFont(myFont);
        newText.setPreferredSize(this.getWidth(), -1);
        newText.setLayout(2048);
        this.insert(this.size() - 1, (Item)newText);
        this.imInput.setString("");
    }

    public String getBuddyName() {
        return this.buddyName;
    }

    public void incomingIM(String message) {
        message = this.stripHTML(message);
        StringItem newText = !this.parent.isTimestamp() ? new StringItem("", this.buddyName + ": " + message) : new StringItem("", "(" + this.formattedDate() + ") " + this.buddyName + ": " + message);
        int fontSize = 8;
        if (this.parent.getChatFontSize() == 2) {
            fontSize = 16;
        }
        if (this.parent.getChatFontSize() == 1) {
            fontSize = 0;
        }
        Font myFont = Font.getFont((int)64, (int)0, (int)fontSize);
        newText.setFont(myFont);
        newText.setPreferredSize(this.getWidth(), -1);
        newText.setLayout(2048);
        this.insert(this.size() - 1, (Item)newText);
        if (this.size() > 20) {
            this.delete(0);
            System.gc();
        }
    }

    private String formattedDate() {
        Calendar tempDate = Calendar.getInstance(TimeZone.getDefault());
        String toRet = tempDate.get(11) + ":" + tempDate.get(12);
        return toRet;
    }

    private String stripHTML(String message) {
        try {
            char[] mess = message.toCharArray();
            boolean writeon = true;
            message = "";
            for (int x = 0; x < mess.length; ++x) {
                if (mess[x] == '<') {
                    writeon = false;
                }
                if (writeon) {
                    message = message + String.valueOf(mess[x]);
                }
                if (mess[x] != '>') continue;
                writeon = true;
            }
            return message;
        }
        catch (OutOfMemoryError ooM) {
            System.err.println("too much HTML!");
            return "";
        }
    }
}

