/*
 * Decompiled with CFR 0.152.
 */
package org.jcochran.j2mechat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import org.jcochran.j2mechat.aimEvent;

public class JavaTOC {
    public String tocHost = "toc.oscar.aol.com";
    public int tocPort = 5190;
    public String authHost = "login.oscar.aol.com";
    public int authPort = 29999;
    public String language = "English";
    public String version = "\"TIC:TOC2\"";
    public String roastString = "Tic/Toc";
    protected int sequence;
    protected SocketConnection connection;
    protected DataInputStream is;
    protected DataOutputStream os;
    protected String id;
    public static final int SIGNON = 1;
    public static final int DATA = 2;
    private String err = "";

    public String getErr() {
        return this.err;
    }

    public boolean login(String id, String password) throws IOException {
        this.id = id;
        this.connection = (SocketConnection)Connector.open((String)("socket://" + this.tocHost + ":" + this.tocPort));
        this.connection.setSocketOption((byte)2, 100000);
        this.is = this.connection.openDataInputStream();
        this.os = this.connection.openDataOutputStream();
        this.sendRaw("FLAPON\r\n\r\n");
        this.getFlap();
        this.sendFlapSignon();
        String command = "toc2_signon " + this.authHost + " " + this.authPort + " " + this.normalize(id) + " " + JavaTOC.imRoast(password) + " " + this.language + " " + this.version + " " + "160" + " " + this.doUserPwdHash(id, password);
        this.sendFlap(2, command);
        command = null;
        aimEvent aEv = this.processTOCEvents();
        if (aEv.getEventType().equals("ERROR")) {
            this.err = aEv.getEventPayload();
            return false;
        }
        aEv = null;
        this.sendFlap(2, "toc_init_done");
        return true;
    }

    public void logout() {
        try {
            this.connection.close();
            this.is.close();
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int doUserPwdHash(String id, String Password) {
        int sn = id.charAt(0) - 96;
        int pw = Password.charAt(0) - 96;
        int a = sn * 7696 + 738816;
        int b = sn * 746512;
        int c = pw * a;
        return c - a + b + 71665152;
    }

    protected String roastPassword(String str) {
        byte[] xor = this.roastString.getBytes();
        int xorIndex = 0;
        String rtn = "0x";
        for (int i = 0; i < str.length(); ++i) {
            String hex = Integer.toHexString(xor[xorIndex] ^ str.charAt(i));
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            rtn = rtn + hex;
            if (++xorIndex != xor.length) continue;
            xorIndex = 0;
        }
        str = null;
        return rtn;
    }

    private void incSeq() {
        this.sequence = this.sequence + 1 & 0xFFFF;
    }

    private static String imRoast(String pass) {
        String roast = "Tic/Toc";
        String out = "";
        String in = pass;
        String out2 = "0x";
        for (int i = 0; i < in.length(); ++i) {
            out = Integer.toHexString(in.charAt(i) ^ roast.charAt(i % 7));
            if (out.length() < 2) {
                out2 = out2 + "0";
            }
            out2 = out2 + out;
        }
        pass = null;
        return out2;
    }

    protected void sendRaw(String str) throws IOException {
        ((OutputStream)this.os).write(str.getBytes());
        this.os.flush();
        str = null;
    }

    protected void writeWord(short word) throws IOException {
        this.os.write((byte)(word >> 8 & 0xFF));
        this.os.write((byte)(word & 0xFF));
    }

    protected void sendFlapSignon() throws IOException {
        int length = 8 + this.id.length();
        this.os.write(42);
        this.os.write(1);
        this.writeWord((short)this.sequence);
        this.writeWord((short)length);
        this.os.write(0);
        this.os.write(0);
        this.os.write(0);
        this.os.write(1);
        this.os.write(0);
        this.os.write(1);
        this.writeWord((short)this.id.length());
        ((OutputStream)this.os).write(this.id.getBytes());
        this.os.flush();
        this.incSeq();
    }

    protected void sendFlap(int type, String str) throws IOException {
        int length = str.length() + 1;
        this.os.write(42);
        this.os.write((byte)type);
        this.writeWord((short)this.sequence);
        this.writeWord((short)length);
        ((OutputStream)this.os).write(str.getBytes());
        this.os.write(0);
        this.os.flush();
        this.incSeq();
    }

    protected String getFlap() throws IOException {
        byte[] a = new byte[1];
        this.is.read(a);
        if (a[0] != 42) {
            return null;
        }
        this.is.read();
        this.is.read();
        this.is.read();
        int length = this.is.read() * 256 + this.is.read();
        byte[] b = new byte[length];
        this.is.read(b);
        a = null;
        return new String(b);
    }

    /*
     * Loose catch block
     */
    public aimEvent processTOCEvents() throws IOException {
        while (true) {
            String str;
            if ((str = this.getFlap()) == null) {
                return null;
            }
            try {
                String eventType = str.substring(0, str.indexOf(":"));
                String payload = str.substring(str.indexOf(":") + 1, str.length());
                aimEvent e = new aimEvent(eventType, payload);
                eventType = null;
                payload = null;
                return e;
            }
            catch (ArrayIndexOutOfBoundsException ar) {
                continue;
            }
            break;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setAway(String awayMessage) {
        try {
            this.sendFlap(2, "toc_set_away \"" + this.encode(awayMessage) + "\"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setInfo(String profile) {
        try {
            this.sendFlap(2, "toc_set_info \"" + this.encode(profile) + "\"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleError(String str) {
    }

    protected void handleIM(String str) {
        System.out.println("ERROR" + str);
    }

    public synchronized void setPriOpt(int PriOpt) {
        try {
            this.sendFlap(2, "toc2_set_pdmode " + Integer.toString(PriOpt) + "\"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void send(String to, String msg) {
        try {
            this.sendFlap(2, "toc2_send_im " + this.normalize(to) + " \"" + this.encode(msg) + "\"");
            to = null;
            msg = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String normalize(String name) {
        String rtn = "";
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') continue;
            rtn = rtn + Character.toLowerCase(name.charAt(i));
        }
        name = null;
        return rtn;
    }

    public void sendInfoRequest(String buddyName) {
        try {
            buddyName = this.normalize(buddyName);
            this.sendFlap(2, "toc_get_info " + buddyName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String encode(String str) {
        String rtn = "";
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\r': {
                    rtn = rtn + "<br>";
                    continue block4;
                }
                case '\"': 
                case '\\': 
                case '{': 
                case '}': {
                    rtn = rtn + "\\";
                }
                default: {
                    rtn = rtn + str.charAt(i);
                }
            }
        }
        str = null;
        return rtn;
    }
}

